/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import com.nokia.mid.appl.calc2.Local;
import java.util.Stack;
import java.util.Vector;
import scientific.BinaryOperator;
import scientific.Number;
import scientific.Operator;
import scientific.Parenthesis;
import scientific.Symbol;
import scientific.UnaryOperator;

public class Parser {
    private static final EOT EOT = new EOT();
    private final Vector term;
    private final boolean isDegrees;
    private Tree tree;
    private int termIdx;
    private Symbol currentToken;

    public Parser(Vector term) {
        this(term, false);
    }

    public Parser(Vector term, boolean isDegrees) {
        this.term = new Vector(term.size());
        Object lastSymbol = null;
        for (int i = 0; i < term.size(); ++i) {
            boolean insertMult = false;
            Symbol currentSymbol = (Symbol)term.elementAt(i);
            if (lastSymbol != null && lastSymbol.equals(Parenthesis.LEFT) && currentSymbol instanceof BinaryOperator && currentSymbol.id == 1) {
                this.term.addElement(new Number("-1"));
                BinaryOperator multiply = new BinaryOperator(2);
                this.term.addElement(multiply);
                lastSymbol = multiply;
                continue;
            }
            if (currentSymbol instanceof UnaryOperator && currentSymbol.getId() == 8) {
                insertMult = false;
            } else if (lastSymbol != null) {
                if (lastSymbol.equals(Parenthesis.LEFT) || currentSymbol.equals(Parenthesis.RIGHT)) {
                    insertMult = false;
                } else if (lastSymbol.equals(Parenthesis.RIGHT) && !(currentSymbol instanceof BinaryOperator)) {
                    insertMult = true;
                } else if (currentSymbol.equals(Parenthesis.LEFT) && !(lastSymbol instanceof Operator)) {
                    insertMult = true;
                } else if (!(currentSymbol instanceof BinaryOperator) && !(lastSymbol instanceof Operator)) {
                    insertMult = true;
                } else if (!(currentSymbol instanceof BinaryOperator) && ((Symbol)lastSymbol).getId() == 8) {
                    insertMult = true;
                }
            }
            if (insertMult) {
                this.term.addElement(new BinaryOperator(2));
            }
            this.term.addElement(currentSymbol);
            lastSymbol = currentSymbol;
        }
        this.term.addElement(EOT);
        this.isDegrees = isDegrees;
    }

    public double parse() throws ArithmeticException, IllegalStateException {
        this.termIdx = -1;
        this.currentToken = null;
        this.tree = new Tree();
        this.expression();
        Symbol root = this.tree.rootNode();
        root.dump("");
        return root.calculate(this.isDegrees);
    }

    private void expression() {
        this.additiveExpression();
    }

    private void additiveExpression() {
        Symbol n;
        this.multiplicativeExpression();
        while (!EOT.equals(n = this.currentToken()) && n instanceof BinaryOperator) {
            if (n.getId() == 0) {
                this.consumeToken(n);
                this.tree.openNodeScope();
                this.multiplicativeExpression();
                this.tree.closeNodeScope(n, 2);
                continue;
            }
            if (n.getId() != 1) break;
            this.consumeToken(n);
            this.tree.openNodeScope();
            this.multiplicativeExpression();
            this.tree.closeNodeScope(n, 2);
        }
    }

    private void multiplicativeExpression() {
        Symbol n;
        this.powerExpression();
        while (!EOT.equals(n = this.currentToken()) && n instanceof BinaryOperator) {
            if (n.getId() == 2) {
                this.consumeToken(n);
                this.tree.openNodeScope();
                this.powerExpression();
                this.tree.closeNodeScope(n, 2);
                continue;
            }
            if (n.getId() != 3) break;
            this.consumeToken(n);
            this.tree.openNodeScope();
            this.powerExpression();
            this.tree.closeNodeScope(n, 2);
        }
    }

    private void powerExpression() {
        Symbol n;
        this.unaryExpression();
        while (!EOT.equals(n = this.currentToken()) && n instanceof BinaryOperator && n.getId() == 4) {
            this.consumeToken(n);
            this.tree.openNodeScope();
            this.powerExpression();
            this.tree.closeNodeScope(n, 2);
        }
    }

    private void unaryExpression() {
        Symbol s = this.currentToken();
        if (EOT.equals(s)) {
            return;
        }
        if (s.equals(Parenthesis.LEFT)) {
            this.consumeToken(s);
            this.expression();
            this.consumeToken(Parenthesis.RIGHT);
        } else if (s instanceof Number) {
            this.number();
        } else if (s instanceof UnaryOperator) {
            this.function();
        } else {
            throw new ArithmeticException(Local.getText(5));
        }
        Symbol t = this.currentToken();
        if (t instanceof UnaryOperator && t.getId() == 8) {
            this.factorial();
        }
    }

    private void number() {
        Symbol s = this.currentToken();
        this.tree.openNodeScope();
        this.consumeToken(s);
        this.tree.closeNodeScope(s, true);
    }

    private void function() {
        Symbol s = this.currentToken();
        this.consumeToken(s);
        this.tree.openNodeScope();
        Symbol arg = this.currentToken();
        if (EOT.equals(arg)) {
            throw new ArithmeticException(Local.getText(13));
        }
        if (arg.equals(Parenthesis.LEFT)) {
            this.consumeToken(arg);
            this.expression();
            this.consumeToken(Parenthesis.RIGHT);
        } else if (arg instanceof Number) {
            this.number();
        } else {
            String error = Local.getText(9, new String[]{s.toString() + " (" + arg + ")"});
            throw new ArithmeticException(error);
        }
        this.tree.closeNodeScope(s, true);
    }

    private void factorial() {
        Symbol s = this.currentToken();
        this.tree.openNodeScope();
        this.consumeToken(s);
        this.tree.closeNodeScope(s, 1);
    }

    private Symbol currentToken() {
        if (this.currentToken != null) {
            return this.currentToken;
        }
        if (++this.termIdx < this.term.size()) {
            this.currentToken = (Symbol)this.term.elementAt(this.termIdx);
            return this.currentToken;
        }
        throw new ArithmeticException(Local.getText(13));
    }

    private void consumeToken(Symbol s) {
        Symbol token = this.currentToken();
        this.currentToken = null;
        if (token.getClass().equals(s.getClass()) && token.getId() == s.getId()) {
            return;
        }
        throw new IllegalStateException("Found unexpected token " + token + "/" + token.getId() + ", expected " + s + "/" + s.getId());
    }

    private static class EOT
    extends Symbol {
        public EOT() {
            super(-1);
        }

        public String toString() {
            return "EOT";
        }

        public double calculate(boolean isDegrees) {
            throw new IllegalStateException("EOT is not used to calculate on node stack.");
        }
    }

    class Tree {
        private Stack nodes = new Stack();
        private Stack marks = new Stack();
        private int sp = 0;
        private int mk = 0;

        private void pushNode(Symbol s) {
            this.nodes.push(s);
            ++this.sp;
        }

        private Symbol popNode() {
            if (--this.sp < this.mk) {
                this.mk = (Integer)this.marks.pop();
            }
            return (Symbol)this.nodes.pop();
        }

        public void openNodeScope() {
            this.marks.push(new Integer(this.mk));
            this.mk = this.sp;
        }

        public void closeNodeScope(Symbol s, int num) {
            if (num > this.nodes.size()) {
                String error = Local.getText(9, new String[]{s.toString()});
                throw new ArithmeticException(error);
            }
            this.mk = (Integer)this.marks.pop();
            while (num-- > 0) {
                Symbol child = this.popNode();
                s.addChild(child, num);
            }
            this.pushNode(s);
        }

        public void closeNodeScope(Symbol s, boolean condition) {
            if (condition) {
                int a = this.nodeArity();
                this.mk = (Integer)this.marks.pop();
                while (a-- > 0) {
                    Symbol child = this.popNode();
                    s.addChild(child, a);
                }
                this.pushNode(s);
            } else {
                this.mk = (Integer)this.marks.pop();
            }
        }

        public int nodeArity() {
            return this.sp - this.mk;
        }

        public Symbol rootNode() {
            return (Symbol)this.nodes.elementAt(0);
        }
    }
}

